/*------------------------------------------------------------------------------*
 * File Name: FitExpGrowth.cpp													*
 * Creation: GRD 2003.05.21													    *
 * Purpose: Origin C file for FitExpGrowth automation							*
 * Copyright (c) OriginLab Corp.2002, 2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 4/13/05 FUNCTION_NAME_WITH_PREFIX											*
 *------------------------------------------------------------------------------*/
#include <origin.h>
#include "FitCommon.h"

#ifdef _FOR_SMART_LOADING_ONLY
#include "analysis_utils.h"
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#endif
#include "NLFitSession.h"
#include "FitNL.h"

//#define PEAK_FUNCTION_NAMES			"Gauss|Lorentz|Asym2Sig|Beta|CCE|ECS|Extreme|GaussAmp|GaussMod|GCAS|Giddings|InvsPoly|LogNormal|Logistpk|PearsonVII|PsdVoigt1|PsdVoigt2|Voigt|Weibull3"

class OC_REGISTERED	FitExpGrowth: public FitNL
{
protected:
	//virtual 
	string GetAnalysisName(int nOption)
	{
		return _L("Fit Exp Growth");
	}
	// Virtual 
	string GetClassName() {return "FitExpGrowth";}

	//virtual 
	bool GetCategoryFuncNames(TreeNode& trOperation, string& strCategory, string& strFunction, vector<string>& vsFilterList)
	{
		//if(NLFitBase::GetCategoryFuncNames(trOperation, strCategory, strFunction, vsFilterList))
		//	return true;
		strCategory = "Exponential";
		///DG 4/13/05 FUNCTION_NAME_WITH_PREFIX
		//vector<string> vsTemp = {"ExpGro1", "ExpGro2", "ExpGro3", "ExpGrow1", "ExpGrow2"};
		vector<string> vsTemp = {"System: ExpGro1", "System: ExpGro2", "System: ExpGro3", "System: ExpGrow1", "System: ExpGrow2"};
		///end FUNCTION_NAME_WITH_PREFIX
		strFunction = vsTemp[0];
		vsFilterList = vsTemp;	
		return false;// indicate Category cannot be changed
	}
};

